#!/bin/bash

if [[ $# -ne 4 ]]; then
	echo "Arguments: virtuosoIni queryFolder timeout outLabel"
	exit 2
fi

timeout=$(($3 * 1000))

echo "Using virtuoso db $1"
echo "Using query folder $2"
echo "Using timeout $3 s $timeout ms"

echo "Starting virtuoso server"
virtuoso-t +configfile $1 &

echo "Sleeping one minute"
sleep 1m

# remove default data
isql 1111 dba dba exec="SPARQL CLEAR GRAPH  <http://www.openlinksw.com/schemas/virtrdf#>; checkpoint; SPARQL CLEAR GRAPH <http://www.w3.org/2002/07/owl#>; SPARQL CLEAR GRAPH <http://localhost:8890/sparql>; SPARQL CLEAR GRAPH <http://localhost:8890/DAV/>; SPARQL CLEAR GRAPH <http://www.w3.org/ns/ldp#>; CHECKPOINT;"

echo "Opening query folder $2"
for file in $2/*.txt; do
	if [[ ! -e $file ]]; then
		echo "No query file with suffix .txt found in folder $2"
		continue
	fi
	queryName=$(basename $file)
	__dir="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
	echo "Opening $file"
	echo "Benchmarking $queryName"
	echo "Writing results to $2/output/${queryName%.*}/$4.txt"
	mkdir -p $2/output/
	mkdir -p $2/output/${queryName%.*}
	python ${__dir}/benchmark.py $2/$queryName http://localhost:8890/sparql $3 > $2/output/${queryName%.*}/$4.txt
	echo "[done]"
done

isql 1111 dba dba exec=shutdown